﻿/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;

/// <summary>
/// CQuestionnaire
/// Gets all data from the DB tables to render instruments on screen 
/// </summary>
public class CQuestionnaire
{
    /// <summary>
    /// Instantiate the BaseMaster Class to be used in the DB transactions
    /// </summary>
    private BaseMaster m_BaseMstr
    { set; get; }

    /// <summary>
    /// Constructor method for CQuestionnaire
    /// </summary>
    /// <param name="BaseMstr"></param>
    public CQuestionnaire(BaseMaster BaseMstr)
    {
        m_BaseMstr = BaseMstr;
    }

    /// <summary>
    /// US:5768
    /// Gets a dataset from INTAKE_MODULE table for the passed in module id
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public DataSet GetModuleDS(long lMID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5768
    /// Gets a dataset from INTAKE_TOPIC table for the passed in module id
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public DataSet GetModuleTopicDS(long lMID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetModuleTopicRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5768
    /// Gets a questions dataset from INTAKE_QUESTION table for the passed in module id, topic id
    /// </summary>
    /// <param name="lMID"></param>
    /// <param name="lTID"></param>
    /// <returns></returns>
    public DataSet GetQuestionDS(long lMID, long lTID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);
        plist.AddInputParameter("pi_nTID", lTID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetQuestionRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5768
    /// Gets a responses dataset from INTAKE_QUESTION table for the passed in module id, topic id and question id
    /// </summary>
    /// <param name="lMID"></param>
    /// <param name="lTID"></param>
    /// <param name="lQID"></param>
    /// <returns></returns>
    public DataSet GetResponseDS(long lMID, long lTID, long lQID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);
        plist.AddInputParameter("pi_nTID", lTID);
        plist.AddInputParameter("pi_nQID", lQID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetResponseRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5768
    /// Gets a dataset used to populate combo boxes (display_type = 4)
    /// </summary>
    /// <param name="lMID"></param>
    /// <param name="lTID"></param>
    /// <param name="lQID"></param>
    /// <param name="lRID"></param>
    /// <returns></returns>
    public DataSet GetStaticDataDS(long lMID, long lTID, long lQID, long lRID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);
        plist.AddInputParameter("pi_nTID", lTID);
        plist.AddInputParameter("pi_nQID", lQID);
        plist.AddInputParameter("pi_nRID", lRID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetStatData",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }


    /// <summary>
    /// US:5768
    /// Combines the dataset for modules, topics, questions, responses then build and returns a nested XML string with all the instrument's data 
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public string GetQuestionnaire(long lMID)
    {

        string str = String.Empty;
        //get module
        DataSet dsModule = this.GetModuleDS(lMID);
        if (dsModule != null)
        {
            var docMod = XDocument.Parse(dsModule.GetXml());

            docMod.Element("NewDataSet").Name = "MODULES";

            foreach (var a in docMod.Element("MODULES").Elements())
            {
                if (a.Name.ToString() == "Table")
                {

                    a.Name = "MODULE";

                    foreach (var m in a.Elements())
                    {
                        if (m.Name.ToString() == "MODULE")
                        {
                            m.Name = "MODULE_TITLE";
                        }
                    }

                    // add topics node -----------
                    a.Add(new XElement("TOPICS"));

                    DataSet dsTopic = this.GetModuleTopicDS(lMID);
                    if (dsTopic != null)
                    {
                        var docTopic = XDocument.Parse(dsTopic.GetXml());
                        foreach (var b in docTopic.Element("NewDataSet").Elements())
                        {
                            if (b.Name.ToString() == "Table")
                            {
                                b.Name = "TOPIC";

                                // add questions node
                                b.Add(new XElement("QUESTIONS"));

                                foreach (var c in b.Elements())
                                {
                                    long lTID = 0;
                                    if (c.Name.ToString() == "TID")
                                    {
                                        lTID = Convert.ToInt32(c.Value);

                                        DataSet dsQuest = this.GetQuestionDS(lMID, lTID);
                                        if (dsQuest != null)
                                        {
                                            var docQuest = XDocument.Parse(dsQuest.GetXml());
                                            foreach (var d in docQuest.Element("NewDataSet").Elements())
                                            {
                                                if (d.Name.ToString() == "Table")
                                                {
                                                    d.Name = "QUESTION";

                                                    // add responses node
                                                    d.Add(new XElement("RESPONSES"));

                                                    foreach (var e in d.Elements())
                                                    {
                                                        long lQID = 0;
                                                        if (e.Name.ToString() == "QID")
                                                        {
                                                            lQID = Convert.ToInt32(e.Value);

                                                            DataSet dsResp = this.GetResponseDS(lMID, lTID, lQID);
                                                            if (dsResp != null)
                                                            {
                                                                var docResp = XDocument.Parse(dsResp.GetXml());

                                                                foreach (var f in docResp.Element("NewDataSet").Elements())
                                                                {
                                                                    if (f.Name.ToString() == "Table")
                                                                    {
                                                                        f.Name = "RESPONSE";

                                                                        // add options node
                                                                        d.Add(new XElement("RESPONSES"));

                                                                        foreach (var g in f.Elements())
                                                                        {
                                                                            long lRID = 0;
                                                                            long.TryParse(f.Element("RID").Value, out lRID);

                                                                            if (g.Name.ToString() == "RESPONSE")
                                                                            {
                                                                                g.Name = "RESPONSE_TEXT";
                                                                            }

                                                                            if (g.Name.ToString() == "DISPLAY_TYPE")
                                                                            {
                                                                                if (g.Value == "4" || g.Value == "22")
                                                                                {
                                                                                    f.Add(new XElement("OPTIONS"));

                                                                                    //get static data for combo box
                                                                                    DataSet dsOptions = this.GetStaticDataDS(lMID, lTID, lQID, lRID);
                                                                                    if (dsOptions != null)
                                                                                    {
                                                                                        var docOptions = XDocument.Parse(dsOptions.GetXml());

                                                                                        foreach (var h in docOptions.Element("NewDataSet").Elements())
                                                                                        {
                                                                                            if (h.Name.ToString() == "Table")
                                                                                            {
                                                                                                h.Name = "OPTION";
                                                                                            }

                                                                                            f.Element("OPTIONS").Add(h);
                                                                                        }
                                                                                    }

                                                                                }
                                                                            }

                                                                        }

                                                                        d.Element("RESPONSES").Add(f);
                                                                    }
                                                                }

                                                            }
                                                        }
                                                    }

                                                    b.Element("QUESTIONS").Add(d);
                                                }
                                            }
                                        }

                                    }
                                }

                                a.Element("TOPICS").Add(b);
                            }
                        }
                    }

                    // -------------------------

                }
            }
            str = docMod.ToString();
        }
        return str;
    }

    /// <summary>
    /// US:5768
    /// Gets a dataset for the responses that contains skip rules
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public DataSet GetSkipPatternDS(long lMID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetSkipPatternRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5768
    /// Builds a JSON string for the skip patterns to be followed in the instrument  
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public string GetSkipPattern(long lMID)
    {
        string s = String.Empty;
        DataSet ds = this.GetSkipPatternDS(lMID);
        if (ds != null)
        {
            s += "{\"skipPattern\": [";
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                bool bDivide = false;
                s += "{";
                s += "\"rid\":" + dr["rid"].ToString() + ",";
                s += "\"checked\": {";

                if (!dr.IsNull("skip_show"))
                {
                    bDivide = true;
                    s += "\"show\": [" + dr["skip_show"].ToString().Replace("'", "\"") + "]";
                }

                if (!dr.IsNull("skip_hide"))
                {
                    if (bDivide)
                    {
                        s += ", ";
                    }

                    s += "\"hide\": [" + dr["skip_hide"].ToString().Replace("'", "\"") + "]";
                }

                s += "}";
                s += "},";
            }

            if (s.Length > 1)
            {
                s = s.Substring(0, s.Length - 1);
            }

            s += "]}";
        }
        return s;
    }

    /// <summary>
    /// US:5768
    /// Gets a dataset for the textbox responses that have an input mask
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public DataSet GetMaskDS(long lMID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nMID", lMID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetMaskRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5768
    /// Builds a JSON string for the input masks to be applied to the textbox controls  
    /// </summary>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public string GetMask(long lMID)
    {
        string s = String.Empty;
        DataSet ds = this.GetMaskDS(lMID);
        if (ds != null)
        {
            s += "{\"txtMasks\": [";
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                bool bDivide = false;
                s += "{";
                s += "\"rid\": " + dr["RID"].ToString() + ",";
                /*s += "\"mask\": \"" + dr["MASK"].ToString() + "\",";
                s += "\"maxlength\": " + dr["MAXLENGTH"].ToString();*/
                s += "\"mask\": \"" + dr["MASK"].ToString() + "\" ";
                s += "},";
            }

            if (s.Length > 1)
            {
                s = s.Substring(0, s.Length - 1);
            }

            s += "]}";
        }
        return s;
    }

    public DataSet GetNextModuleDS(string strPatientDFN, string strMDWSSiteID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientDFN);
        plist.AddInputParameter("pi_vSiteID", strMDWSSiteID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_QUESTIONNAIRES.GetNextModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }


}